<?php

require_once 'config.inc';
require_once 'DB.php';
require_once 'HTML/QuickForm.php';

$form = new HTML_QuickForm('reguser');
$form->addElement('header', null, 'Agregar usuario');
$form->addElement('text', 'nombre', 'Nombre:', array('size'=>40));
$form->addElement('text', 'email', 'Email:', array('size'=>40));
$form->addElement('submit', 'submit_form', 'Agregar');
$form->applyFilter('name', 'trim');
$form->applyFilter('email', 'trim');
$form->addRule('nombre', 'Nombre es necesario', 'required', null, 'client');
$form->addRule('email', 'Email es necesario', 'required', null, 'client');
$form->addRule('email', 'Email correcto es necesario', 'email', null, 'client');

if ($form->validate()) {
    $form->freeze();
    $form->removeElement('submit_form');
    $values = $form->exportValues();
    $db = DB::connect(DATABASE_DSN);
    $sql = 'insert into users (nombre, email) values(?, ?)';
    $r = $db->query($sql, array($values['nombre'], $values['email']));
    if (DB::isError($r)) {
        echo 'Error: '.$r->getMessage();
    } else {
        echo "Usuario agregado correctamente:<br />";
    }
}

$form->display();

?>
